/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.server;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.net.PlayerStatePacket;
import de.maxhenkel.voicechat.net.PlayerStatesPacket;
import de.maxhenkel.voicechat.net.RemovePlayerStatePacket;
import de.maxhenkel.voicechat.plugins.PluginManager;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import de.maxhenkel.voicechat.voice.server.Server;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;

public class PlayerStateManager {
    private final ConcurrentHashMap<UUID, PlayerState> states;
    private final Server voicechatServer;

    public PlayerStateManager(Server voicechatServer) {
        this.voicechatServer = voicechatServer;
        this.states = new ConcurrentHashMap();
        CommonCompatibilityManager.INSTANCE.getNetManager().updateStateChannel.setServerListener((server, player, handler, packet) -> {
            PlayerState state = this.states.get(player.func_110124_au());
            if (state == null) {
                state = PlayerStateManager.defaultDisconnectedState(player);
            }
            state.setDisabled(packet.isDisabled());
            this.states.put(player.func_110124_au(), state);
            this.broadcastState(player, state);
            Voicechat.LOGGER.debug("Got state of {}: {}", player.func_70005_c_(), state);
        });
    }

    public void broadcastState(@Nullable EntityPlayerMP stateOwner, PlayerState state) {
        PlayerStatePacket packet = new PlayerStatePacket(state);
        for (EntityPlayerMP receiver : this.voicechatServer.getServer().func_184103_al().func_181057_v()) {
            if (stateOwner != null && !CommonCompatibilityManager.INSTANCE.canSee(receiver, stateOwner)) continue;
            NetManager.sendToClient(receiver, packet);
        }
        PluginManager.instance().onPlayerStateChanged(state);
    }

    public void broadcastRemoveState(EntityPlayerMP stateOwner) {
        RemovePlayerStatePacket packet = new RemovePlayerStatePacket(stateOwner.func_110124_au());
        for (EntityPlayerMP receiver : this.voicechatServer.getServer().func_184103_al().func_181057_v()) {
            NetManager.sendToClient(receiver, packet);
        }
        PluginManager.instance().onPlayerStateChanged(PlayerStateManager.defaultDisconnectedState(stateOwner));
    }

    public void onPlayerCompatibilityCheckSucceeded(EntityPlayerMP player) {
        ArrayList<PlayerState> stateList = new ArrayList<PlayerState>(this.states.size());
        for (PlayerState state : this.states.values()) {
            EntityPlayerMP otherPlayer = this.voicechatServer.getServer().func_184103_al().func_177451_a(state.getUuid());
            if (otherPlayer == null || !CommonCompatibilityManager.INSTANCE.canSee(player, otherPlayer)) continue;
            stateList.add(state);
        }
        PlayerStatesPacket packet = new PlayerStatesPacket(stateList);
        NetManager.sendToClient(player, packet);
        Voicechat.LOGGER.debug("Sending initial states to {}", player.func_70005_c_());
    }

    public void onPlayerLoggedIn(EntityPlayerMP player) {
        PlayerState state = PlayerStateManager.defaultDisconnectedState(player);
        this.states.put(player.func_110124_au(), state);
        this.broadcastState(player, state);
        Voicechat.LOGGER.debug("Setting default state of {}: {}", player.func_70005_c_(), state);
    }

    public void onPlayerLoggedOut(EntityPlayerMP player) {
        this.states.remove(player.func_110124_au());
        this.broadcastRemoveState(player);
        Voicechat.LOGGER.debug("Removing state of {}", player.func_146103_bH().getName());
    }

    public void onPlayerHide(EntityPlayerMP visibilityChangedPlayer, EntityPlayerMP observingPlayer) {
        RemovePlayerStatePacket packet = new RemovePlayerStatePacket(visibilityChangedPlayer.func_110124_au());
        NetManager.sendToClient(observingPlayer, packet);
        Voicechat.LOGGER.debug("Removing state of {} for {}", visibilityChangedPlayer.func_146103_bH().getName(), observingPlayer.func_146103_bH().getName());
    }

    public void onPlayerShow(EntityPlayerMP visibilityChangedPlayer, EntityPlayerMP observingPlayer) {
        PlayerState state = this.states.get(visibilityChangedPlayer.func_110124_au());
        if (state == null) {
            state = PlayerStateManager.defaultDisconnectedState(visibilityChangedPlayer);
        }
        PlayerStatePacket packet = new PlayerStatePacket(state);
        NetManager.sendToClient(observingPlayer, packet);
        Voicechat.LOGGER.debug("Sending state of {} to {}", visibilityChangedPlayer.func_146103_bH().getName(), observingPlayer.func_146103_bH().getName());
    }

    public void onPlayerVoicechatDisconnect(UUID uuid) {
        PlayerState state = this.states.get(uuid);
        if (state == null) {
            return;
        }
        state.setDisconnected(true);
        EntityPlayerMP player = this.voicechatServer.getServer().func_184103_al().func_177451_a(uuid);
        this.broadcastState(player, state);
        Voicechat.LOGGER.debug("Set state of {} to disconnected: {}", uuid, state);
    }

    public void onPlayerVoicechatConnect(EntityPlayerMP player) {
        PlayerState state = this.states.get(player.func_110124_au());
        if (state == null) {
            state = PlayerStateManager.defaultDisconnectedState(player);
        }
        state.setDisconnected(false);
        this.states.put(player.func_110124_au(), state);
        this.broadcastState(player, state);
        Voicechat.LOGGER.debug("Set state of {} to connected: {}", player.func_70005_c_(), state);
    }

    @Nullable
    public PlayerState getState(UUID playerUUID) {
        return this.states.get(playerUUID);
    }

    public static PlayerState defaultDisconnectedState(EntityPlayerMP player) {
        return new PlayerState(player.func_110124_au(), player.func_146103_bH().getName(), false, true);
    }

    public void setGroup(EntityPlayerMP player, @Nullable UUID group) {
        PlayerState state = this.states.get(player.func_110124_au());
        if (state == null) {
            state = PlayerStateManager.defaultDisconnectedState(player);
            Voicechat.LOGGER.debug("Defaulting to default state for {}: {}", player.func_70005_c_(), state);
        }
        state.setGroup(group);
        this.states.put(player.func_110124_au(), state);
        this.broadcastState(player, state);
        Voicechat.LOGGER.debug("Setting group of {}: {}", player.func_70005_c_(), state);
    }

    public Collection<PlayerState> getStates() {
        return this.states.values();
    }
}

