/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.HoverEvent;

public class ChatUtils {
    public static void sendModErrorMessage(String translationKey, @Nullable String errorMessage) {
        Style style = new Style().func_150238_a(TextFormatting.RED);
        if (errorMessage != null) {
            style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new TextComponentString(errorMessage).func_150255_a(new Style().func_150238_a(TextFormatting.RED))));
        }
        ITextComponent message = ChatUtils.wrapInSquareBrackets((ITextComponent)new TextComponentString(CommonCompatibilityManager.INSTANCE.getModName())).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)).func_150258_a(" ").func_150257_a(new TextComponentTranslation(translationKey, new Object[0]).func_150255_a(style));
        ChatUtils.sendPlayerMessage(message);
    }

    private static ITextComponent wrapInSquareBrackets(ITextComponent component) {
        return new TextComponentString("[").func_150257_a(component).func_150258_a("]");
    }

    public static void sendModErrorMessage(String translationKey, @Nullable Exception e) {
        ChatUtils.sendModErrorMessage(translationKey, e == null ? null : e.getMessage());
    }

    public static void sendModErrorMessage(String translationKey) {
        ChatUtils.sendModErrorMessage(translationKey, (String)null);
    }

    public static void sendModMessage(ITextComponent message) {
        ChatUtils.sendPlayerMessage(ChatUtils.createModMessage(message));
    }

    public static ITextComponent createModMessage(ITextComponent message) {
        return new TextComponentString("").func_150257_a(ChatUtils.wrapInSquareBrackets((ITextComponent)new TextComponentString(CommonCompatibilityManager.INSTANCE.getModName())).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN))).func_150258_a(" ").func_150257_a(message);
    }

    public static void sendPlayerMessage(ITextComponent component) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        player.func_145747_a(component);
    }
}

