/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.resourcepacks;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import de.maxhenkel.voicechat.Voicechat;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.io.IOUtils;

public class VoiceChatResourcePack
implements IResourcePack {
    protected String path;
    protected ITextComponent name;

    public VoiceChatResourcePack(String path, ITextComponent name) {
        this.path = path;
        this.name = name;
    }

    private String getPath() {
        return "/packs/" + this.path + "/";
    }

    private String getAssetsPath() {
        return "/packs/" + this.path + "/assets/" + "voicechat" + "/";
    }

    @Nullable
    private InputStream get(String name) {
        return Voicechat.class.getResourceAsStream(this.getPath() + name);
    }

    @Nullable
    private InputStream getAsset(String name) {
        return Voicechat.class.getResourceAsStream(this.getAssetsPath() + name);
    }

    public InputStream func_110590_a(ResourceLocation location) throws IOException {
        if (!location.func_110624_b().equals("voicechat")) {
            throw new FileNotFoundException("Resource " + location + " does not exist");
        }
        InputStream resourceAsStream = this.getAsset(location.func_110623_a());
        if (resourceAsStream == null) {
            throw new FileNotFoundException("Resource " + location + " does not exist");
        }
        return resourceAsStream;
    }

    public boolean func_110589_b(ResourceLocation location) {
        if (!location.func_110624_b().equals("voicechat")) {
            return false;
        }
        try {
            return this.getAsset(location.func_110623_a()) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Set<String> func_110587_b() {
        return ImmutableSet.of((Object)"voicechat");
    }

    private static <T extends IMetadataSection> T readMetadata(MetadataSerializer metadataSerializer, InputStream inputStream, String sectionName) {
        JsonObject jsonobject;
        BufferedReader bufferedreader = null;
        try {
            bufferedreader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            jsonobject = new JsonParser().parse((Reader)bufferedreader).getAsJsonObject();
        }
        catch (RuntimeException runtimeexception) {
            try {
                throw new JsonParseException((Throwable)runtimeexception);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedreader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)bufferedreader);
        return (T)metadataSerializer.func_110503_a(sectionName, jsonobject);
    }

    @Nullable
    public <T extends IMetadataSection> T func_135058_a(MetadataSerializer metadataSerializer, String metadataSectionName) throws IOException {
        InputStream inputStream = this.get("pack.mcmeta");
        if (inputStream == null) {
            throw new FileNotFoundException("pack.mcmeta does not exist");
        }
        return VoiceChatResourcePack.readMetadata(metadataSerializer, inputStream, metadataSectionName);
    }

    public BufferedImage func_110586_a() throws IOException {
        InputStream inputStream = this.get("pack.png");
        if (inputStream == null) {
            throw new FileNotFoundException("pack.png does not exist");
        }
        return TextureUtil.func_177053_a((InputStream)inputStream);
    }

    public String func_130077_b() {
        return this.name.func_150254_d();
    }
}

