/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.plugins.impl.audiochannel;

import de.maxhenkel.voicechat.api.VoicechatConnection;
import de.maxhenkel.voicechat.api.audiochannel.StaticAudioChannel;
import de.maxhenkel.voicechat.api.packets.MicrophonePacket;
import de.maxhenkel.voicechat.plugins.impl.VoicechatServerApiImpl;
import de.maxhenkel.voicechat.plugins.impl.audiochannel.AudioChannelImpl;
import de.maxhenkel.voicechat.voice.common.GroupSoundPacket;
import de.maxhenkel.voicechat.voice.server.ClientConnection;
import de.maxhenkel.voicechat.voice.server.Group;
import de.maxhenkel.voicechat.voice.server.Server;
import de.maxhenkel.voicechat.voice.server.ServerGroupManager;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.management.PlayerList;

public class StaticAudioChannelImpl
extends AudioChannelImpl
implements StaticAudioChannel {
    protected boolean bypassGroupIsolation;
    protected final Set<UUID> targets = new HashSet<UUID>();

    public StaticAudioChannelImpl(UUID channelId, Server server) {
        super(channelId, server);
    }

    @Override
    public void send(byte[] opusData) {
        this.broadcast(new GroupSoundPacket(this.channelId, this.channelId, opusData, this.sequenceNumber.getAndIncrement(), this.category));
    }

    @Override
    public void send(MicrophonePacket packet) {
        this.send(packet.getOpusEncodedData());
    }

    @Override
    public void flush() {
        GroupSoundPacket packet = new GroupSoundPacket(this.channelId, this.channelId, new byte[0], this.sequenceNumber.getAndIncrement(), this.category);
        this.broadcast(packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcast(GroupSoundPacket packet) {
        Set<UUID> set = this.targets;
        synchronized (set) {
            PlayerList playerList = this.server.getServer().func_184103_al();
            ServerGroupManager groupManager = this.server.getGroupManager();
            for (UUID target : this.targets) {
                Group playerGroup;
                EntityPlayerMP player;
                ClientConnection connection = this.server.getConnection(target);
                if (connection == null || (player = playerList.func_177451_a(target)) == null || !this.bypassGroupIsolation && (playerGroup = groupManager.getPlayerGroup(player)) != null && playerGroup.isIsolated()) continue;
                VoicechatServerApiImpl.sendPacket(player, packet);
            }
        }
    }

    @Override
    public void setBypassGroupIsolation(boolean bypassGroupIsolation) {
        this.bypassGroupIsolation = bypassGroupIsolation;
    }

    @Override
    public boolean bypassesGroupIsolation() {
        return this.bypassGroupIsolation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTarget(VoicechatConnection target) {
        Set<UUID> set = this.targets;
        synchronized (set) {
            this.targets.add(target.getPlayer().getUuid());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTarget(VoicechatConnection target) {
        Set<UUID> set = this.targets;
        synchronized (set) {
            this.targets.remove(target.getPlayer().getUuid());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearTargets() {
        Set<UUID> set = this.targets;
        synchronized (set) {
            this.targets.clear();
        }
    }
}

