/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.plugins.impl;

import de.maxhenkel.voicechat.api.VolumeCategory;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public class VolumeCategoryImpl
implements VolumeCategory {
    public static final Pattern ID_REGEX = Pattern.compile("^[a-z_]{1,16}$");
    private final String id;
    private final String name;
    @Nullable
    private final String nameTranslationKey;
    @Nullable
    private final String description;
    @Nullable
    private final String descriptionTranslationKey;
    @Nullable
    private final int[][] icon;

    public VolumeCategoryImpl(String id, String name, @Nullable String nameTranslationKey, @Nullable String description, @Nullable String descriptionTranslationKey, @Nullable int[][] icon) {
        if (!ID_REGEX.matcher(id).matches()) {
            throw new IllegalArgumentException("Volume category ID can only contain a-z and _ with a maximum amount of 16 characters");
        }
        this.id = id;
        this.name = name;
        this.nameTranslationKey = nameTranslationKey;
        this.description = description;
        this.descriptionTranslationKey = descriptionTranslationKey;
        this.icon = icon;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getNameTranslationKey() {
        return this.nameTranslationKey;
    }

    public ITextComponent getDisplayName() {
        if (this.nameTranslationKey != null && I18n.func_188566_a((String)this.nameTranslationKey)) {
            return new TextComponentTranslation(this.nameTranslationKey, new Object[0]);
        }
        return new TextComponentString(this.name);
    }

    public String getSearchName() {
        if (this.nameTranslationKey == null) {
            return this.name;
        }
        if (I18n.func_188566_a((String)this.nameTranslationKey)) {
            return I18n.func_135052_a((String)this.nameTranslationKey, (Object[])new Object[0]);
        }
        return this.name;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public ITextComponent getDisplayDescription() {
        if (this.descriptionTranslationKey != null && I18n.func_188566_a((String)this.descriptionTranslationKey)) {
            return new TextComponentTranslation(this.descriptionTranslationKey, new Object[0]);
        }
        return this.description != null ? new TextComponentString(this.description) : new TextComponentString("");
    }

    @Override
    @Nullable
    public String getDescriptionTranslationKey() {
        return this.descriptionTranslationKey;
    }

    @Override
    @Nullable
    public int[][] getIcon() {
        return this.icon;
    }

    public static VolumeCategoryImpl fromBytes(PacketBuffer buf) {
        String id = buf.func_150789_c(16);
        String name = buf.func_150789_c(16);
        String nameTranslationKey = VolumeCategoryImpl.readOptionalString(buf);
        String description = VolumeCategoryImpl.readOptionalString(buf);
        String descriptionTranslationKey = VolumeCategoryImpl.readOptionalString(buf);
        int[][] icon = null;
        if (buf.readBoolean()) {
            icon = new int[16][16];
            for (int x = 0; x < icon.length; ++x) {
                for (int y = 0; y < icon.length; ++y) {
                    icon[x][y] = buf.readInt();
                }
            }
        }
        return new VolumeCategoryImpl(id, name, nameTranslationKey, description, descriptionTranslationKey, icon);
    }

    @Nullable
    private static String readOptionalString(PacketBuffer buf) {
        if (buf.readBoolean()) {
            return buf.func_150789_c(Short.MAX_VALUE);
        }
        return null;
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_180714_a(this.id);
        buf.func_180714_a(this.name);
        VolumeCategoryImpl.writeOptionalString(buf, this.nameTranslationKey);
        VolumeCategoryImpl.writeOptionalString(buf, this.description);
        VolumeCategoryImpl.writeOptionalString(buf, this.descriptionTranslationKey);
        buf.writeBoolean(this.icon != null);
        if (this.icon != null) {
            if (this.icon.length != 16) {
                throw new IllegalStateException("Icon is not 16x16");
            }
            for (int x = 0; x < this.icon.length; ++x) {
                if (this.icon[x].length != 16) {
                    throw new IllegalStateException("Icon is not 16x16");
                }
                for (int y = 0; y < this.icon.length; ++y) {
                    buf.writeInt(this.icon[x][y]);
                }
            }
        }
    }

    private static void writeOptionalString(PacketBuffer buf, @Nullable String string) {
        buf.writeBoolean(string != null);
        if (string != null) {
            buf.func_180714_a(string);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        VolumeCategoryImpl that = (VolumeCategoryImpl)object;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public static class BuilderImpl
    implements VolumeCategory.Builder {
        private String id;
        private String name;
        @Nullable
        private String nameTranslationKey;
        @Nullable
        private String description;
        @Nullable
        private String descriptionTranslationKey;
        @Nullable
        private int[][] icon;

        @Override
        public VolumeCategory.Builder setId(String id) {
            this.id = id;
            return this;
        }

        @Override
        public VolumeCategory.Builder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public VolumeCategory.Builder setNameTranslationKey(@Nullable String translationKey) {
            this.nameTranslationKey = translationKey;
            return this;
        }

        @Override
        public VolumeCategory.Builder setDescription(@Nullable String description) {
            this.description = description;
            return this;
        }

        @Override
        public VolumeCategory.Builder setDescriptionTranslationKey(@Nullable String translationKey) {
            this.descriptionTranslationKey = translationKey;
            return this;
        }

        @Override
        public VolumeCategory.Builder setIcon(@Nullable int[][] icon) {
            this.icon = icon;
            return this;
        }

        @Override
        public VolumeCategory build() {
            if (this.id == null) {
                throw new IllegalStateException("id missing");
            }
            if (this.name == null) {
                throw new IllegalStateException("name missing");
            }
            return new VolumeCategoryImpl(this.id, this.name, this.nameTranslationKey, this.description, this.descriptionTranslationKey, this.icon);
        }
    }
}

