/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.widgets;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.debug.VoicechatUncaughtExceptionHandler;
import de.maxhenkel.voicechat.gui.widgets.ImageButton;
import de.maxhenkel.voicechat.gui.widgets.ToggleImageButton;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.MicThread;
import de.maxhenkel.voicechat.voice.client.MicrophoneException;
import de.maxhenkel.voicechat.voice.client.speaker.Speaker;
import de.maxhenkel.voicechat.voice.client.speaker.SpeakerException;
import de.maxhenkel.voicechat.voice.client.speaker.SpeakerManager;
import de.maxhenkel.voicechat.voice.common.AudioUtils;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class MicTestButton
extends ToggleImageButton
implements ImageButton.TooltipSupplier {
    private static final ResourceLocation MICROPHONE = new ResourceLocation("voicechat", "textures/icons/microphone_button.png");
    private static final ITextComponent TEST_DISABLED = new TextComponentTranslation("message.voicechat.mic_test.disabled", new Object[0]);
    private static final ITextComponent TEST_ENABLED = new TextComponentTranslation("message.voicechat.mic_test.enabled", new Object[0]);
    private static final ITextComponent TEST_UNAVAILABLE = new TextComponentTranslation("message.voicechat.mic_test_unavailable", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED));
    private boolean micActive;
    @Nullable
    private VoiceThread voiceThread;
    @Nullable
    private final MicListener micListener;
    private final boolean raw;
    @Nullable
    private final ClientVoicechat client;

    public MicTestButton(int id, int xIn, int yIn, boolean raw, @Nullable MicListener micListener) {
        super(id, xIn, yIn, MICROPHONE, null, null, null);
        this.raw = raw;
        this.micListener = micListener;
        this.client = ClientManager.getClient();
        this.stateSupplier = () -> !this.micActive;
        this.tooltipSupplier = this;
    }

    public MicTestButton(int id, int xIn, int yIn, boolean raw) {
        this(id, xIn, yIn, raw, null);
    }

    @Override
    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        super.func_191745_a(mc, mouseX, mouseY, partialTicks);
        this.updateLastRender();
    }

    public void updateLastRender() {
        if (this.field_146125_m && this.voiceThread != null) {
            this.voiceThread.updateLastRender();
        }
    }

    public void setMicActive(boolean micActive) {
        this.micActive = micActive;
    }

    public boolean isHovered() {
        return this.field_146123_n;
    }

    public boolean isMicActive() {
        return this.micActive;
    }

    @Override
    public void onPress() {
        this.setMicActive(!this.micActive);
        if (this.micActive) {
            this.close();
            try {
                this.voiceThread = new VoiceThread();
                this.voiceThread.start();
            }
            catch (Exception e) {
                this.setMicActive(false);
                this.field_146124_l = false;
                Voicechat.LOGGER.error("Microphone error", e);
            }
        } else {
            this.close();
        }
    }

    private void close() {
        if (this.voiceThread != null) {
            this.voiceThread.close();
            this.voiceThread = null;
        }
    }

    public void stop() {
        this.close();
        this.setMicActive(false);
    }

    @Override
    public void onTooltip(ImageButton button, int mouseX, int mouseY) {
        GuiScreen screen = this.mc.field_71462_r;
        if (screen == null) {
            return;
        }
        if (!this.field_146124_l) {
            screen.func_146279_a(TEST_UNAVAILABLE.func_150254_d(), mouseX, mouseY);
            return;
        }
        if (this.micActive) {
            screen.func_146279_a(TEST_ENABLED.func_150254_d(), mouseX, mouseY);
        } else {
            screen.func_146279_a(TEST_DISABLED.func_150254_d(), mouseX, mouseY);
        }
        GlStateManager.func_179140_f();
    }

    public static interface MicListener {
        public void onMicValue(double var1);

        public void onStop();
    }

    private class VoiceThread
    extends Thread {
        private final Speaker speaker;
        private boolean running = true;
        private long lastRender;
        private MicThread micThread;
        private boolean usesOwnMicThread;

        public VoiceThread() throws SpeakerException, MicrophoneException {
            this.setDaemon(true);
            this.setName("VoiceTestingThread");
            this.setUncaughtExceptionHandler(new VoicechatUncaughtExceptionHandler());
            MicThread micThread = this.micThread = MicTestButton.this.client != null ? MicTestButton.this.client.getMicThread() : null;
            if (this.micThread == null) {
                this.micThread = new MicThread(MicTestButton.this.client, null);
                this.usesOwnMicThread = true;
            }
            this.speaker = SpeakerManager.createSpeaker(null, null);
            this.updateLastRender();
            this.setMicLocked(true);
        }

        @Override
        public void run() {
            while (this.running && System.currentTimeMillis() - this.lastRender <= 500L && !this.micThread.isClosed()) {
                short[] buff = MicTestButton.this.raw ? this.micThread.pollMic() : this.micThread.pollProcessedAudio(true);
                if (buff == null) continue;
                if (MicTestButton.this.micListener != null) {
                    MicTestButton.this.micListener.onMicValue(AudioUtils.getHighestAudioLevel(buff));
                }
                if (!MicTestButton.this.raw && !this.micThread.shouldTransmitAudio()) continue;
                this.play(buff);
            }
            this.speaker.close();
            this.setMicLocked(false);
            if (MicTestButton.this.micListener != null) {
                MicTestButton.this.micListener.onStop();
            }
            if (this.usesOwnMicThread) {
                this.micThread.close();
            }
            MicTestButton.this.setMicActive(false);
            Voicechat.LOGGER.info("Mic test audio channel closed", new Object[0]);
        }

        private void play(short[] buff) {
            this.speaker.play(buff, ((Double)VoicechatClient.CLIENT_CONFIG.voiceChatVolume.get()).floatValue(), null);
        }

        public void updateLastRender() {
            this.lastRender = System.currentTimeMillis();
        }

        private void setMicLocked(boolean locked) {
            this.micThread.setMicrophoneLocked(locked);
        }

        public void close() {
            if (!this.running) {
                return;
            }
            Voicechat.LOGGER.info("Stopping mic test audio channel", new Object[0]);
            this.running = false;
            try {
                this.join();
            }
            catch (InterruptedException e) {
                Voicechat.LOGGER.warn("Failed to close microphone", e);
            }
        }
    }
}

