/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.volume;

import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.GameProfileUtils;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumeSlider;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumesScreen;
import de.maxhenkel.voicechat.gui.volume.VolumeEntry;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;

public class PlayerVolumeEntry
extends VolumeEntry {
    @Nullable
    protected final PlayerState state;

    public PlayerVolumeEntry(@Nullable PlayerState state, AdjustVolumesScreen screen) {
        super(screen, new AdjustPlayerVolumeEntry(state != null ? state.getUuid() : new UUID(0L, 0L), state != null ? state.getName() : null));
        this.state = state;
    }

    @Nullable
    public PlayerState getState() {
        return this.state;
    }

    @Override
    public void renderElement(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks, int skinX, int skinY, int textX, int textY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.state != null) {
            this.minecraft.func_110434_K().func_110577_a(GameProfileUtils.getSkin(this.state.getUuid()));
            Gui.func_152125_a((int)skinX, (int)skinY, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)24, (int)24, (float)64.0f, (float)64.0f);
            GlStateManager.func_179147_l();
            Gui.func_152125_a((int)skinX, (int)skinY, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)24, (int)24, (float)64.0f, (float)64.0f);
            GlStateManager.func_179084_k();
            this.minecraft.field_71466_p.func_78276_b(this.state.getName(), textX, textY, PLAYER_NAME_COLOR);
        } else {
            this.minecraft.func_110434_K().func_110577_a(OTHER_VOLUME_ICON);
            Gui.func_152125_a((int)skinX, (int)skinY, (float)16.0f, (float)16.0f, (int)16, (int)16, (int)24, (int)24, (float)16.0f, (float)16.0f);
            this.minecraft.field_71466_p.func_78276_b(OTHER_VOLUME.func_150261_e(), textX, textY, PLAYER_NAME_COLOR);
            if (isSelected) {
                this.screen.postRender(() -> this.screen.func_146279_a(OTHER_VOLUME_DESCRIPTION.func_150261_e(), mouseX, mouseY));
            }
        }
    }

    public static class AdjustPlayerVolumeEntry
    implements AdjustVolumeSlider.AdjustVolumeEntry {
        private final UUID playerUUID;
        @Nullable
        private final String playerName;

        public AdjustPlayerVolumeEntry(UUID playerUUID, @Nullable String playerName) {
            this.playerUUID = playerUUID;
            this.playerName = playerName;
        }

        @Override
        public void save(double value) {
            VoicechatClient.PLAYER_VOLUME_CONFIG.setVolume(this.playerUUID, value, this.playerName == null ? "All other volumes" : String.format("Volume of %s", this.playerName));
            VoicechatClient.PLAYER_VOLUME_CONFIG.save();
        }

        @Override
        public double get() {
            return VoicechatClient.PLAYER_VOLUME_CONFIG.getVolume(this.playerUUID);
        }

        @Override
        public double getAudioLevel() {
            ClientVoicechat client = ClientManager.getClient();
            if (client == null) {
                return -127.0;
            }
            return client.getTalkCache().getPlayerAudioLevel(this.playerUUID);
        }
    }
}

