/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.command;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.permission.PermissionManager;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import de.maxhenkel.voicechat.voice.server.ClientConnection;
import de.maxhenkel.voicechat.voice.server.Group;
import de.maxhenkel.voicechat.voice.server.PingManager;
import de.maxhenkel.voicechat.voice.server.Server;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class VoicechatCommand
extends CommandBase {
    public static final String VOICECHAT_COMMAND = "voicechat";

    public String func_71517_b() {
        return VOICECHAT_COMMAND;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/voicechat <help|test|invite|join|leave>";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender commandSender, String[] args) throws CommandException {
        if (VoicechatCommand.checkNoVoicechat(commandSender)) {
            return;
        }
        if (!(commandSender instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP sender = (EntityPlayerMP)commandSender;
        if (args.length >= 1) {
            if (args[0].equalsIgnoreCase("help")) {
                this.helpCommand(sender, args);
                return;
            }
            if (args[0].equalsIgnoreCase("test")) {
                if (PermissionManager.INSTANCE.ADMIN_PERMISSION.hasPermission(sender)) {
                    this.testCommand(sender, args);
                    return;
                }
            } else {
                if (args[0].equalsIgnoreCase("invite")) {
                    this.inviteCommand(sender, args);
                    return;
                }
                if (args[0].equalsIgnoreCase("join")) {
                    this.joinCommand(sender, args);
                    return;
                }
                if (args[0].equalsIgnoreCase("leave")) {
                    this.leaveCommand(sender);
                    return;
                }
            }
        }
        this.helpCommand(sender, args);
    }

    private boolean helpCommand(EntityPlayerMP commandSender, String[] args) {
        commandSender.func_145747_a((ITextComponent)new TextComponentString("/voicechat [help]"));
        commandSender.func_145747_a((ITextComponent)new TextComponentString("/voicechat [test] <target>"));
        commandSender.func_145747_a((ITextComponent)new TextComponentString("/voicechat [invite] <target>"));
        commandSender.func_145747_a((ITextComponent)new TextComponentString("/voicechat [join] <group> [<password>]"));
        commandSender.func_145747_a((ITextComponent)new TextComponentString("/voicechat [leave]"));
        return true;
    }

    private boolean testCommand(final EntityPlayerMP commandSender, String[] args) {
        if (args.length < 2) {
            return false;
        }
        EntityPlayerMP player = commandSender.func_184102_h().func_184103_al().func_152612_a(args[1]);
        if (player == null) {
            commandSender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.generic.player.notFound", new Object[]{args[1]}));
            return true;
        }
        if (!Voicechat.SERVER.isCompatible(player)) {
            commandSender.func_145747_a((ITextComponent)new TextComponentTranslation("message.voicechat.player_no_voicechat", new Object[]{player.func_145748_c_(), new TextComponentString(CommonCompatibilityManager.INSTANCE.getModName())}));
            return true;
        }
        ClientConnection clientConnection = Voicechat.SERVER.getServer().getConnections().get(player.func_110124_au());
        if (clientConnection == null) {
            commandSender.func_145747_a((ITextComponent)new TextComponentTranslation("message.voicechat.client_not_connected", new Object[0]));
            return true;
        }
        try {
            commandSender.func_145747_a((ITextComponent)new TextComponentTranslation("message.voicechat.sending_ping", new Object[0]));
            Voicechat.SERVER.getServer().getPingManager().sendPing(clientConnection, 500L, 10, new PingManager.PingListener(){

                @Override
                public void onPong(int attempts, long pingMilliseconds) {
                    if (attempts <= 1) {
                        commandSender.func_145747_a((ITextComponent)new TextComponentTranslation("message.voicechat.ping_received", new Object[]{new TextComponentString(String.valueOf(pingMilliseconds))}));
                    } else {
                        commandSender.func_145747_a((ITextComponent)new TextComponentTranslation("message.voicechat.ping_received_attempt", new Object[]{new TextComponentString(String.valueOf(pingMilliseconds)), new TextComponentString(String.valueOf(attempts))}));
                    }
                }

                @Override
                public void onFailedAttempt(int attempts) {
                    commandSender.func_145747_a((ITextComponent)new TextComponentTranslation("message.voicechat.ping_retry", new Object[0]));
                }

                @Override
                public void onTimeout(int attempts) {
                    commandSender.func_145747_a((ITextComponent)new TextComponentTranslation("message.voicechat.ping_timed_out", new Object[]{new TextComponentString(String.valueOf(attempts))}));
                }
            });
            commandSender.func_145747_a((ITextComponent)new TextComponentTranslation("message.voicechat.ping_sent_waiting", new Object[0]));
        }
        catch (Exception e) {
            commandSender.func_145747_a((ITextComponent)new TextComponentTranslation("message.voicechat.failed_to_send_ping", new Object[]{new TextComponentString(String.valueOf(e.getMessage()))}));
            Voicechat.LOGGER.warn("Failed to send ping", e);
        }
        return true;
    }

    private boolean inviteCommand(EntityPlayerMP commandSender, String[] args) {
        if (args.length < 2) {
            return false;
        }
        EntityPlayerMP player = VoicechatCommand.parsePlayer((ICommandSender)commandSender, args[1]);
        if (player == null) {
            commandSender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.generic.player.notFound", new Object[]{args[1]}));
            return true;
        }
        PlayerState state = Voicechat.SERVER.getServer().getPlayerStateManager().getState(commandSender.func_110124_au());
        if (state == null || !state.hasGroup()) {
            commandSender.func_145747_a((ITextComponent)new TextComponentTranslation("message.voicechat.not_in_group", new Object[0]));
            return true;
        }
        Group group = Voicechat.SERVER.getServer().getGroupManager().getGroup(state.getGroup());
        if (group == null) {
            return true;
        }
        if (!Voicechat.SERVER.isCompatible(player)) {
            commandSender.func_145747_a((ITextComponent)new TextComponentTranslation("message.voicechat.player_no_voicechat", new Object[]{player.func_145748_c_(), new TextComponentString(CommonCompatibilityManager.INSTANCE.getModName())}));
            return true;
        }
        String passwordSuffix = group.getPassword() == null ? "" : " \"" + group.getPassword() + "\"";
        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.voicechat.invite", new Object[]{new TextComponentString(commandSender.func_70005_c_()), new TextComponentString(group.getName()).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)), new TextComponentString("[").func_150257_a(new TextComponentTranslation("message.voicechat.accept_invite", new Object[0]).func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/voicechat join " + group.getId().toString() + passwordSuffix)).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentTranslation("message.voicechat.accept_invite.hover", new Object[0]))).func_150238_a(TextFormatting.GREEN)).func_150258_a("]").func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)))}));
        commandSender.func_145747_a((ITextComponent)new TextComponentTranslation("message.voicechat.invite_successful", new Object[]{new TextComponentString(player.func_70005_c_())}));
        return true;
    }

    private boolean joinCommand(EntityPlayerMP player, String[] args) {
        UUID groupUUID;
        int argIndex;
        if (args.length < 2) {
            return false;
        }
        try {
            groupUUID = UUID.fromString(args[argIndex]);
        }
        catch (Exception e) {
            String groupName;
            if (args[argIndex].startsWith("\"")) {
                String[] split;
                StringBuilder sb = new StringBuilder();
                for (argIndex = 1; argIndex < args.length; ++argIndex) {
                    sb.append(args[argIndex]).append(" ");
                    if (args[argIndex].endsWith("\"") && !args[argIndex].endsWith("\\\"")) break;
                }
                if ((split = (groupName = sb.toString().trim()).split("\"")).length > 1) {
                    groupName = split[1];
                }
            } else {
                groupName = args[argIndex];
            }
            groupUUID = this.getGroupUUID(player, Voicechat.SERVER.getServer(), groupName);
        }
        if (groupUUID == null) {
            return true;
        }
        String password = null;
        if (args.length >= ++argIndex + 1) {
            String[] split;
            StringBuilder sb = new StringBuilder();
            while (argIndex < args.length) {
                sb.append(args[argIndex]).append(" ");
                ++argIndex;
            }
            password = sb.toString().trim();
            if (password.startsWith("\"") && (split = password.split("\"")).length > 1) {
                password = split[1];
            }
        }
        VoicechatCommand.joinGroup(player, groupUUID, password);
        return true;
    }

    private UUID getGroupUUID(EntityPlayerMP player, Server server, String groupName) {
        List groups = server.getGroupManager().getGroups().values().stream().filter(group -> group.getName().equals(groupName)).collect(Collectors.toList());
        if (groups.isEmpty()) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.voicechat.group_does_not_exist", new Object[0]));
            return null;
        }
        if (groups.size() > 1) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.voicechat.group_name_not_unique", new Object[0]));
            return null;
        }
        return ((Group)groups.get(0)).getId();
    }

    private static void joinGroup(EntityPlayerMP player, UUID groupID, @Nullable String password) {
        if (!Voicechat.SERVER_CONFIG.groupsEnabled.get().booleanValue()) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.voicechat.groups_disabled", new Object[0]));
            return;
        }
        Server server = Voicechat.SERVER.getServer();
        if (!PermissionManager.INSTANCE.GROUPS_PERMISSION.hasPermission(player)) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.voicechat.no_group_permission", new Object[0]));
            return;
        }
        Group group = server.getGroupManager().getGroup(groupID);
        if (group == null) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.voicechat.group_does_not_exist", new Object[0]));
            return;
        }
        server.getGroupManager().joinGroup(group, player, password);
        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.voicechat.join_successful", new Object[]{new TextComponentString(group.getName()).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN))}));
    }

    private boolean leaveCommand(EntityPlayerMP player) {
        if (!Voicechat.SERVER_CONFIG.groupsEnabled.get().booleanValue()) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.voicechat.groups_disabled", new Object[0]));
            return true;
        }
        Server server = Voicechat.SERVER.getServer();
        PlayerState state = server.getPlayerStateManager().getState(player.func_110124_au());
        if (state == null || !state.hasGroup()) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.voicechat.not_in_group", new Object[0]));
            return true;
        }
        server.getGroupManager().leaveGroup(player);
        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.voicechat.leave_successful", new Object[0]));
        return true;
    }

    private static boolean checkNoVoicechat(ICommandSender commandSender) {
        if (commandSender instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)commandSender;
            if (Voicechat.SERVER.isCompatible(player)) {
                return false;
            }
            commandSender.func_145747_a((ITextComponent)new TextComponentString(String.format(Voicechat.TRANSLATIONS.voicechatNeededForCommandMessage.get(), CommonCompatibilityManager.INSTANCE.getModName())));
        } else {
            commandSender.func_145747_a((ITextComponent)new TextComponentString(Voicechat.TRANSLATIONS.playerCommandMessage.get()));
        }
        return true;
    }

    @Nullable
    public static EntityPlayerMP parsePlayer(ICommandSender commandSender, String playerArg) {
        EntityPlayerMP player = commandSender.func_184102_h().func_184103_al().func_152612_a(playerArg);
        if (player != null) {
            return player;
        }
        try {
            UUID uuid = UUID.fromString(playerArg);
            return commandSender.func_184102_h().func_184103_al().func_177451_a(uuid);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

